from __future__ import annotations

import sys


# 允许从项目根目录或 src 目录直接运行
if __name__ == "__main__" and (__package__ is None or __package__ == ""):
    import pathlib

    this_dir = pathlib.Path(__file__).resolve().parent
    if str(this_dir) not in sys.path:
        sys.path.insert(0, str(this_dir))


def main() -> int:
    """
    程序统一启动入口。

    约束（当前阶段）：
    - 不从命令行传参
    - 后续通过配置文件控制参数时，在此处读取配置并构造 AlarmConfig
    """
    from alarm_demo import run_alarm_monitoring

    run_alarm_monitoring()
    return 0


if __name__ == "__main__":
    raise SystemExit(main())